﻿Partial Public Class MainPage
    Inherits PhoneApplicationPage
    Private photoChooser As New PhotoChooserTask()


    Public Sub New()
        InitializeComponent()
        AddHandler photoChooser.Completed, AddressOf OnPhotoChooserCompleted
    End Sub


    Protected Overrides Sub OnManipulationStarted(ByVal args As ManipulationStartedEventArgs)
        Dim dimension = CInt(Math.Min(ContentPanel.ActualWidth,
                                                 ContentPanel.ActualHeight)) - 8

        photoChooser.PixelHeight = dimension
        photoChooser.PixelWidth = dimension
        photoChooser.Show()

        args.Complete()
        args.Handled = True
        MyBase.OnManipulationStarted(args)
    End Sub


    Private Sub OnPhotoChooserCompleted(ByVal sender As Object, ByVal args As PhotoResult)
        If args.Error IsNot Nothing OrElse args.ChosenPhoto Is Nothing Then
            Return
        End If

        Dim bitmapImage As New BitmapImage()
        bitmapImage.SetSource(args.ChosenPhoto)

        Dim imgBase As New Image()
        imgBase.Source = bitmapImage
        imgBase.Stretch = Stretch.None

        ' Upper-left
        Dim writeableBitmap As New WriteableBitmap(bitmapImage.PixelWidth \ 2,
                                                   bitmapImage.PixelHeight \ 2)
        writeableBitmap.Render(imgBase, Nothing)
        writeableBitmap.Invalidate()
        imgUL.Source = writeableBitmap

        ' Upper-right
        writeableBitmap = New WriteableBitmap(bitmapImage.PixelWidth \ 2,
                                              bitmapImage.PixelHeight \ 2)
        Dim translate As New TranslateTransform()
        translate.X = -bitmapImage.PixelWidth \ 2
        writeableBitmap.Render(imgBase, translate)
        writeableBitmap.Invalidate()
        imgUR.Source = writeableBitmap

        ' Lower-left
        writeableBitmap = New WriteableBitmap(bitmapImage.PixelWidth \ 2,
                                              bitmapImage.PixelHeight \ 2)
        translate.X = 0
        translate.Y = -bitmapImage.PixelHeight \ 2
        writeableBitmap.Render(imgBase, translate)
        writeableBitmap.Invalidate()
        imgLL.Source = writeableBitmap

        ' Lower-right
        writeableBitmap = New WriteableBitmap(bitmapImage.PixelWidth \ 2,
                                              bitmapImage.PixelHeight \ 2)
        translate.X = -bitmapImage.PixelWidth \ 2
        writeableBitmap.Render(imgBase, translate)
        writeableBitmap.Invalidate()
        imgLR.Source = writeableBitmap

        txtblk.Visibility = System.Windows.Visibility.Collapsed
    End Sub
End Class